(function () {
  'use strict';

  // Wait for DOM to be ready
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }

  function init() {
    // Get elements
    const toggleBtn = document.getElementById('toggleAllCheckboxes');
    const resetBtn = document.getElementById('resetToDefaults');
    const status = document.getElementById('admin-action-status');

    // Check if we're on the admin page
    if (!toggleBtn || !resetBtn || !status) {
      return;
    }

    // Get default values from global variable (localized from PHP)
    const defaults = window.roiCalculatorDefaults || {};

    // Toggle all checkboxes with aria-pressed and announce
    toggleBtn.addEventListener('click', function () {
      const boxes = document.querySelectorAll('.visibility-checkbox');
      const allChecked = Array.from(boxes).every(cb => cb.checked);
      boxes.forEach(cb => cb.checked = !allChecked);
      const newState = !allChecked ? 'All items marked visible' : 'All items hidden from calculator';
      toggleBtn.setAttribute('aria-pressed', (!allChecked).toString());
      status.textContent = newState;
    });

    // Reset to defaults
    resetBtn.addEventListener('click', function () {
      if (!confirm('Are you sure you want to reset all costs to their default values? This will also check all visibility checkboxes.')) {
        status.textContent = 'Reset cancelled';
        return;
      }

      // Reset all costs to defaults
      for (const key in defaults) {
        const input = document.getElementById('library_value_calculator_options[items][' + key + '][cost]');
        if (input) {
          input.value = defaults[key];
        }
      }

      // Check all visibility checkboxes
      const checkboxes = document.querySelectorAll('.visibility-checkbox');
      checkboxes.forEach(cb => cb.checked = true);

      status.textContent = 'All values have been reset to defaults. Click Save Changes to apply.';
    });
  }
})();